/*
 * Decompiled with CFR 0.152.
 */
package com.zkryle.jeg.common.golem;

import com.zkryle.jeg.core.Init;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class EnragedGolemSpikeEntity
extends Entity {
    private int lifeTicks = 32;
    private float raiseAnim = 0.0f;

    public EnragedGolemSpikeEntity(EntityType<EnragedGolemSpikeEntity> p_i48580_1_, World p_i48580_2_) {
        super(p_i48580_1_, p_i48580_2_);
    }

    private EnragedGolemSpikeEntity(World p_i47276_1_, double p_i47276_2_, double p_i47276_4_, double p_i47276_6_, float p_i47276_8_) {
        this((EntityType<EnragedGolemSpikeEntity>)((EntityType)Init.ENRAGED_GOLEM_SPIKE_ENTITY.get()), p_i47276_1_);
        this.field_70177_z = p_i47276_8_ * 57.295776f;
        this.func_70107_b(p_i47276_2_, p_i47276_4_, p_i47276_6_);
    }

    public static EnragedGolemSpikeEntity createEnragedGolemSpikeEntity(World level, double p_i47276_2_, double p_i47276_4_, double p_i47276_6_, float p_i47276_8_) {
        return new EnragedGolemSpikeEntity(level, p_i47276_2_, p_i47276_4_, p_i47276_6_, p_i47276_8_);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.func_201670_d()) {
            if (this.lifeTicks == 32) {
                this.field_70170_p.func_184133_a(null, this.func_233580_cy_(), (SoundEvent)Init.ENRAGED_GOLEM_SPIKE_SOUND.get(), SoundCategory.HOSTILE, 0.7f, 1.0f);
            }
            for (LivingEntity livingentity : this.field_70170_p.func_217357_a(LivingEntity.class, this.func_174813_aQ().func_72314_b(0.2, 0.0, 0.2))) {
                this.dealDamageTo(livingentity);
            }
        }
        if (--this.lifeTicks < 0) {
            this.func_70106_y();
        }
        if (this.raiseAnim < 1.0f) {
            this.raiseAnim += 0.1f;
        }
    }

    private void dealDamageTo(LivingEntity p_190551_1_) {
        if (p_190551_1_.func_70089_S() && !p_190551_1_.func_190530_aW()) {
            p_190551_1_.func_70097_a(DamageSource.field_76376_m, 4.0f);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getAnimationProgress(float pPartialTicks) {
        int i = this.lifeTicks - 2;
        return i <= 0 ? 1.0f : 1.0f - ((float)i - pPartialTicks) / 20.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getRaiseAnim() {
        return this.raiseAnim;
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(CompoundNBT pCompound) {
    }

    protected void func_213281_b(CompoundNBT pCompound) {
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

